# [GameHub](https://tkashkin.tk/projects/gamehub) [![Build status](https://ci.appveyor.com/api/projects/status/cgw5hc4kos4uvmy9/branch/master?svg=true)](https://ci.appveyor.com/project/tkashkin/gamehub/branch/master) [![Translation status](https://hosted.weblate.org/widgets/gamehub/-/translations/svg-badge.svg)](https://hosted.weblate.org/engage/gamehub/?utm_source=widget)
Mirrors: [GitHub](https://github.com/tkashkin/GameHub), [codeberg.org](https://codeberg.org/tkashkin/GameHub), [repo.or.cz](https://repo.or.cz/GameHub.git), [git.froggi.es](https://git.froggi.es/tkashkin/gamehub)

## Overview
GameHub is a unified library for all your games. It allows you to store your games from different platforms into one program to make it easier for you to manage your games.

### [Features](https://tkashkin.tk/projects/gamehub/#/features)
With GameHub, you can:
* store your games in one place
* login to multiple platforms
* install games from the supported sources
* download game installers, DLCs and bonus content
* automatically find artwork for games on [SteamGridDB](https://steamgriddb.com)
* setup emulators and automatically import emulated games

GameHub also has features like:
* [Overlays](https://tkashkin.tk/projects/gamehub/#/overlays) — multiple directories applied on top of each other. Each overlay is stored separately and doesn't affect other overlays. Overlays can be useful to manage DLCs and mods
* [Tweaks](https://github.com/tkashkin/GameHub/wiki/Tweaks) — environment variable and command line overrides that can be applied to games automatically

GameHub supports:
* native games for Linux
* multiple [compatibility layers](https://github.com/tkashkin/GameHub/wiki/Compatibility-layers):
	- Wine
	- Proton
	- DOSBox
	- RetroArch
	- ScummVM
	- [WineWrap](https://www.gog.com/forum/general/adamhms_linux_wine_wrappers_news_faq_discussion/post1) — a set of preconfigured wrappers for [supported games](https://www.gog.com/forum/general/adamhms_linux_wine_wrappers_news_faq_discussion/post3);
	- custom emulators
* multiple game platforms:
	- Steam
	- GOG
	- Humble Bundle (including Humble Trove)
	- itch.io

## Installation
See [INSTALL.md](INSTALL.md).

## Building
See [INSTALL.md#Source](INSTALL.md#build-from-source).

## [Screenshots](https://tkashkin.tk/projects/gamehub/#/screenshots)
<p align="center"><img src="data/screenshots/light/welcome.png?raw=true" width="49%" /> <img src="data/screenshots/dark/grid.png?raw=true" width="49%" /><img src="data/screenshots/dark/list.png?raw=true" width="49%" /> <img src="data/screenshots/light/grid_controller.png?raw=true" width="49%" /><img src="data/screenshots/light/details.png?raw=true" width="49%" /> <img src="data/screenshots/dark/settings_collection.png?raw=true" width="49%" /><img src="data/screenshots/dark/overlays.png?raw=true" width="49%" /> <img src="data/screenshots/light/install.png?raw=true" width="49%" /><img src="data/screenshots/light/properties.png?raw=true" width="49%" /> <img src="data/screenshots/dark/install_compat.png?raw=true" width="49%" /></p>
