//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armqumulo

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FileSystemsClient contains the methods for the FileSystems group.
// Don't use this type directly, use NewFileSystemsClient() instead.
type FileSystemsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFileSystemsClient creates a new instance of FileSystemsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFileSystemsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FileSystemsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FileSystemsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - fileSystemName - Name of the File System resource
//   - resource - Resource create parameters.
//   - options - FileSystemsClientBeginCreateOrUpdateOptions contains the optional parameters for the FileSystemsClient.BeginCreateOrUpdate
//     method.
func (client *FileSystemsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, fileSystemName string, resource FileSystemResource, options *FileSystemsClientBeginCreateOrUpdateOptions) (*runtime.Poller[FileSystemsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, fileSystemName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FileSystemsClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FileSystemsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
func (client *FileSystemsClient) createOrUpdate(ctx context.Context, resourceGroupName string, fileSystemName string, resource FileSystemResource, options *FileSystemsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "FileSystemsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, fileSystemName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *FileSystemsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, fileSystemName string, resource FileSystemResource, options *FileSystemsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Qumulo.Storage/fileSystems/{fileSystemName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if fileSystemName == "" {
		return nil, errors.New("parameter fileSystemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileSystemName}", url.PathEscape(fileSystemName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - fileSystemName - Name of the File System resource
//   - options - FileSystemsClientBeginDeleteOptions contains the optional parameters for the FileSystemsClient.BeginDelete method.
func (client *FileSystemsClient) BeginDelete(ctx context.Context, resourceGroupName string, fileSystemName string, options *FileSystemsClientBeginDeleteOptions) (*runtime.Poller[FileSystemsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, fileSystemName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FileSystemsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FileSystemsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
func (client *FileSystemsClient) deleteOperation(ctx context.Context, resourceGroupName string, fileSystemName string, options *FileSystemsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "FileSystemsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, fileSystemName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FileSystemsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, fileSystemName string, options *FileSystemsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Qumulo.Storage/fileSystems/{fileSystemName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if fileSystemName == "" {
		return nil, errors.New("parameter fileSystemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileSystemName}", url.PathEscape(fileSystemName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - fileSystemName - Name of the File System resource
//   - options - FileSystemsClientGetOptions contains the optional parameters for the FileSystemsClient.Get method.
func (client *FileSystemsClient) Get(ctx context.Context, resourceGroupName string, fileSystemName string, options *FileSystemsClientGetOptions) (FileSystemsClientGetResponse, error) {
	var err error
	const operationName = "FileSystemsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, fileSystemName, options)
	if err != nil {
		return FileSystemsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileSystemsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileSystemsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FileSystemsClient) getCreateRequest(ctx context.Context, resourceGroupName string, fileSystemName string, options *FileSystemsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Qumulo.Storage/fileSystems/{fileSystemName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if fileSystemName == "" {
		return nil, errors.New("parameter fileSystemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileSystemName}", url.PathEscape(fileSystemName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FileSystemsClient) getHandleResponse(resp *http.Response) (FileSystemsClientGetResponse, error) {
	result := FileSystemsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileSystemResource); err != nil {
		return FileSystemsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List FileSystemResource resources by resource group
//
// Generated from API version 2022-10-12
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - FileSystemsClientListByResourceGroupOptions contains the optional parameters for the FileSystemsClient.NewListByResourceGroupPager
//     method.
func (client *FileSystemsClient) NewListByResourceGroupPager(resourceGroupName string, options *FileSystemsClientListByResourceGroupOptions) *runtime.Pager[FileSystemsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSystemsClientListByResourceGroupResponse]{
		More: func(page FileSystemsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FileSystemsClientListByResourceGroupResponse) (FileSystemsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSystemsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return FileSystemsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *FileSystemsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *FileSystemsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Qumulo.Storage/fileSystems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *FileSystemsClient) listByResourceGroupHandleResponse(resp *http.Response) (FileSystemsClientListByResourceGroupResponse, error) {
	result := FileSystemsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileSystemResourceListResult); err != nil {
		return FileSystemsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List FileSystemResource resources by subscription ID
//
// Generated from API version 2022-10-12
//   - options - FileSystemsClientListBySubscriptionOptions contains the optional parameters for the FileSystemsClient.NewListBySubscriptionPager
//     method.
func (client *FileSystemsClient) NewListBySubscriptionPager(options *FileSystemsClientListBySubscriptionOptions) *runtime.Pager[FileSystemsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSystemsClientListBySubscriptionResponse]{
		More: func(page FileSystemsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FileSystemsClientListBySubscriptionResponse) (FileSystemsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSystemsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return FileSystemsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *FileSystemsClient) listBySubscriptionCreateRequest(ctx context.Context, options *FileSystemsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Qumulo.Storage/fileSystems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *FileSystemsClient) listBySubscriptionHandleResponse(resp *http.Response) (FileSystemsClientListBySubscriptionResponse, error) {
	result := FileSystemsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileSystemResourceListResult); err != nil {
		return FileSystemsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Update a FileSystemResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-12
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - fileSystemName - Name of the File System resource
//   - properties - The resource properties to be updated.
//   - options - FileSystemsClientUpdateOptions contains the optional parameters for the FileSystemsClient.Update method.
func (client *FileSystemsClient) Update(ctx context.Context, resourceGroupName string, fileSystemName string, properties FileSystemResourceUpdate, options *FileSystemsClientUpdateOptions) (FileSystemsClientUpdateResponse, error) {
	var err error
	const operationName = "FileSystemsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, fileSystemName, properties, options)
	if err != nil {
		return FileSystemsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileSystemsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileSystemsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *FileSystemsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, fileSystemName string, properties FileSystemResourceUpdate, options *FileSystemsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Qumulo.Storage/fileSystems/{fileSystemName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if fileSystemName == "" {
		return nil, errors.New("parameter fileSystemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileSystemName}", url.PathEscape(fileSystemName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-12")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *FileSystemsClient) updateHandleResponse(resp *http.Response) (FileSystemsClientUpdateResponse, error) {
	result := FileSystemsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileSystemResource); err != nil {
		return FileSystemsClientUpdateResponse{}, err
	}
	return result, nil
}
