//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
)

// PolicyRestrictionsServer is a fake server for instances of the armpolicyinsights.PolicyRestrictionsClient type.
type PolicyRestrictionsServer struct {
	// CheckAtManagementGroupScope is the fake for method PolicyRestrictionsClient.CheckAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK
	CheckAtManagementGroupScope func(ctx context.Context, managementGroupID string, parameters armpolicyinsights.CheckManagementGroupRestrictionsRequest, options *armpolicyinsights.PolicyRestrictionsClientCheckAtManagementGroupScopeOptions) (resp azfake.Responder[armpolicyinsights.PolicyRestrictionsClientCheckAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// CheckAtResourceGroupScope is the fake for method PolicyRestrictionsClient.CheckAtResourceGroupScope
	// HTTP status codes to indicate success: http.StatusOK
	CheckAtResourceGroupScope func(ctx context.Context, resourceGroupName string, parameters armpolicyinsights.CheckRestrictionsRequest, options *armpolicyinsights.PolicyRestrictionsClientCheckAtResourceGroupScopeOptions) (resp azfake.Responder[armpolicyinsights.PolicyRestrictionsClientCheckAtResourceGroupScopeResponse], errResp azfake.ErrorResponder)

	// CheckAtSubscriptionScope is the fake for method PolicyRestrictionsClient.CheckAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK
	CheckAtSubscriptionScope func(ctx context.Context, parameters armpolicyinsights.CheckRestrictionsRequest, options *armpolicyinsights.PolicyRestrictionsClientCheckAtSubscriptionScopeOptions) (resp azfake.Responder[armpolicyinsights.PolicyRestrictionsClientCheckAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)
}

// NewPolicyRestrictionsServerTransport creates a new instance of PolicyRestrictionsServerTransport with the provided implementation.
// The returned PolicyRestrictionsServerTransport instance is connected to an instance of armpolicyinsights.PolicyRestrictionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyRestrictionsServerTransport(srv *PolicyRestrictionsServer) *PolicyRestrictionsServerTransport {
	return &PolicyRestrictionsServerTransport{srv: srv}
}

// PolicyRestrictionsServerTransport connects instances of armpolicyinsights.PolicyRestrictionsClient to instances of PolicyRestrictionsServer.
// Don't use this type directly, use NewPolicyRestrictionsServerTransport instead.
type PolicyRestrictionsServerTransport struct {
	srv *PolicyRestrictionsServer
}

// Do implements the policy.Transporter interface for PolicyRestrictionsServerTransport.
func (p *PolicyRestrictionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyRestrictionsClient.CheckAtManagementGroupScope":
		resp, err = p.dispatchCheckAtManagementGroupScope(req)
	case "PolicyRestrictionsClient.CheckAtResourceGroupScope":
		resp, err = p.dispatchCheckAtResourceGroupScope(req)
	case "PolicyRestrictionsClient.CheckAtSubscriptionScope":
		resp, err = p.dispatchCheckAtSubscriptionScope(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyRestrictionsServerTransport) dispatchCheckAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if p.srv.CheckAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckAtManagementGroupScope not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/checkPolicyRestrictions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.CheckManagementGroupRestrictionsRequest](req)
	if err != nil {
		return nil, err
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CheckAtManagementGroupScope(req.Context(), managementGroupIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckRestrictionsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyRestrictionsServerTransport) dispatchCheckAtResourceGroupScope(req *http.Request) (*http.Response, error) {
	if p.srv.CheckAtResourceGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckAtResourceGroupScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/checkPolicyRestrictions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.CheckRestrictionsRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CheckAtResourceGroupScope(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckRestrictionsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyRestrictionsServerTransport) dispatchCheckAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if p.srv.CheckAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckAtSubscriptionScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/checkPolicyRestrictions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.CheckRestrictionsRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.CheckAtSubscriptionScope(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckRestrictionsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
