//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpostgresql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresql"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/stable/2017-12-01/examples/ConfigurationCreateOrUpdate.json
func ExampleConfigurationsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewConfigurationsClient().BeginCreateOrUpdate(ctx, "TestGroup", "testserver", "array_nulls", armpostgresql.Configuration{
		Properties: &armpostgresql.ConfigurationProperties{
			Source: to.Ptr("user-override"),
			Value:  to.Ptr("off"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Configuration = armpostgresql.Configuration{
	// 	Name: to.Ptr("array_nulls"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/array_nulls"),
	// 	Properties: &armpostgresql.ConfigurationProperties{
	// 		Description: to.Ptr("Enable input of NULL elements in arrays."),
	// 		AllowedValues: to.Ptr("on,off"),
	// 		DataType: to.Ptr("Boolean"),
	// 		DefaultValue: to.Ptr("on"),
	// 		Source: to.Ptr("user-override"),
	// 		Value: to.Ptr("off"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/stable/2017-12-01/examples/ConfigurationGet.json
func ExampleConfigurationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConfigurationsClient().Get(ctx, "TestGroup", "testserver", "array_nulls", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Configuration = armpostgresql.Configuration{
	// 	Name: to.Ptr("array_nulls"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/array_nulls"),
	// 	Properties: &armpostgresql.ConfigurationProperties{
	// 		Description: to.Ptr("Enable input of NULL elements in arrays."),
	// 		AllowedValues: to.Ptr("on,off"),
	// 		DataType: to.Ptr("Boolean"),
	// 		DefaultValue: to.Ptr("on"),
	// 		Source: to.Ptr("system-default"),
	// 		Value: to.Ptr("on"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/stable/2017-12-01/examples/ConfigurationListByServer.json
func ExampleConfigurationsClient_NewListByServerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConfigurationsClient().NewListByServerPager("TestGroup", "testserver", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConfigurationListResult = armpostgresql.ConfigurationListResult{
		// 	Value: []*armpostgresql.Configuration{
		// 		{
		// 			Name: to.Ptr("array_nulls"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/array_nulls"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enable input of NULL elements in arrays."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("backslash_quote"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/backslash_quote"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets whether \"\\'\" is allowed in string literals."),
		// 				AllowedValues: to.Ptr("safe_encoding,on,off"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("safe_encoding"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("safe_encoding"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bytea_output"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/bytea_output"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the output format for bytea."),
		// 				AllowedValues: to.Ptr("escape,hex"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("hex"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("hex"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("check_function_bodies"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/check_function_bodies"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Check function bodies during CREATE FUNCTION."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("client_encoding"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/client_encoding"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the client's character set encoding."),
		// 				AllowedValues: to.Ptr("BIG5,EUC_CN,EUC_JP,EUC_JIS_2004,EUC_KR,EUC_TW,GB18030,GBK,ISO_8859_5,ISO_8859_6,ISO_8859_7,ISO_8859_8,JOHAB,KOI8R,KOI8U,LATIN1,LATIN2,LATIN3,LATIN4,LATIN5,LATIN6,LATIN7,LATIN8,LATIN9,LATIN10,MULE_INTERNAL,SJIS,SHIFT_JIS_2004,SQL_ASCII,UHC,UTF8,WIN866,WIN874,WIN1250,WIN1251,WIN1252,WIN1253,WIN1254,WIN1255,WIN1256,WIN1257,WIN1258"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("sql_ascii"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("sql_ascii"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("client_min_messages"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/client_min_messages"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the message levels that are sent to the client."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,log,notice,warning,error"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("notice"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("notice"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("constraint_exclusion"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/constraint_exclusion"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner to use constraints to optimize queries."),
		// 				AllowedValues: to.Ptr("partition,on,off"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("partition"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("partition"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_index_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/cpu_index_tuple_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each index entry during an index scan."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.005"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.005"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_operator_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/cpu_operator_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each operator or function call."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.0025"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.0025"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/cpu_tuple_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each tuple (row)."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.01"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.01"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cursor_tuple_fraction"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/cursor_tuple_fraction"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the fraction of a cursor's rows that will be retrieved."),
		// 				AllowedValues: to.Ptr("0-1"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("datestyle"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/datestyle"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the display format for date and time values."),
		// 				AllowedValues: to.Ptr("(iso|postgres|sql|german)\\,\\s(dmy|mdy|ymd)"),
		// 				DataType: to.Ptr("String"),
		// 				DefaultValue: to.Ptr("iso, mdy"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("iso, mdy"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("deadlock_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/deadlock_timeout"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the amount of time, in milliseconds, to wait on a lock before checking for deadlock."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("1000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_parse"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/debug_print_parse"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's parse tree."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_plan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/debug_print_plan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's execution plan."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_rewritten"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/debug_print_rewritten"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's rewritten parse tree."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_statistics_target"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_statistics_target"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default statistics target."),
		// 				AllowedValues: to.Ptr("1-10000"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("100"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("100"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_text_search_config"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_text_search_config"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets default text search configuration."),
		// 				AllowedValues: to.Ptr("[A-Za-z\\._]+"),
		// 				DataType: to.Ptr("String"),
		// 				DefaultValue: to.Ptr("pg_catalog.english"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("pg_catalog.english"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_deferrable"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_transaction_deferrable"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default deferrable status of new transactions."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_isolation"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_transaction_isolation"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the transaction isolation level of each new transaction."),
		// 				AllowedValues: to.Ptr("serializable,repeatable read,read committed,read uncommitted"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("read committed"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("read committed"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_read_only"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_transaction_read_only"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default read-only status of new transactions."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_with_oids"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/default_with_oids"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Create new tables with OIDs by default."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_bitmapscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_bitmapscan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of bitmap-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_hashagg"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_hashagg"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of hashed aggregation plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_hashjoin"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_hashjoin"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of hash join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_indexonlyscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_indexonlyscan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of index-only-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_indexscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_indexscan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of index-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_material"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_material"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of materialization."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_mergejoin"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_mergejoin"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of merge join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_nestloop"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_nestloop"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of nested-loop join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_seqscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_seqscan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of sequential-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_sort"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_sort"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of explicit sort steps."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_tidscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/enable_tidscan"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of TID scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("escape_string_warning"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/escape_string_warning"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Warn about backslash escapes in ordinary string literals."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("exit_on_error"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/exit_on_error"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Terminate session on any error."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("extra_float_digits"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/extra_float_digits"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the number of digits displayed for floating-point values."),
		// 				AllowedValues: to.Ptr("-15-3"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("from_collapse_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/from_collapse_limit"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the FROM-list size beyond which subqueries are not collapsed."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enables genetic query optimization."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_effort"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_effort"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: effort is used to set the default for other GEQO parameters."),
		// 				AllowedValues: to.Ptr("1-10"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("5"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("5"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_generations"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_generations"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: number of iterations of the algorithm."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_pool_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_pool_size"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: number of individuals in the population."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_seed"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_seed"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: seed for random path selection."),
		// 				AllowedValues: to.Ptr("0-1"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_selection_bias"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_selection_bias"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: selective pressure within the population."),
		// 				AllowedValues: to.Ptr("1.5-2"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("2.0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_threshold"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/geqo_threshold"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the threshold of FROM items beyond which GEQO is used."),
		// 				AllowedValues: to.Ptr("2-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("12"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("12"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("gin_fuzzy_search_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/gin_fuzzy_search_limit"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed result for exact search by GIN."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("intervalstyle"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/intervalstyle"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the display format for interval values."),
		// 				AllowedValues: to.Ptr("postgres,postgres_verbose,sql_standard,iso_8601"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("postgres"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("postgres"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("join_collapse_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/join_collapse_limit"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the FROM-list size beyond which JOIN constructs are not flattened."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("lock_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/lock_timeout"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration (in milliseconds) of any wait for a lock. 0 turns this off."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_checkpoints"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_checkpoints"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each checkpoint."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_connections"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_connections"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each successful connection."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_disconnections"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_disconnections"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs end of a session, including duration."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_duration"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_duration"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs the duration of each completed SQL statement."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_error_verbosity"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_error_verbosity"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the verbosity of logged messages."),
		// 				AllowedValues: to.Ptr("terse,default,verbose"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("default"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("default"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_lock_waits"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_lock_waits"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Logs long lock waits."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_duration_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_min_duration_statement"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum execution time (in milliseconds) above which statements will be logged. -1 disables logging statement durations."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_error_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_min_error_statement"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Causes all statements generating error at or above this level to be logged."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,info,notice,warning,error,log,fatal,panic"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("error"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("error"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_messages"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_min_messages"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the message levels that are logged."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,info,notice,warning,error,log,fatal,panic"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("warning"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("warning"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_statement"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the type of statements logged."),
		// 				AllowedValues: to.Ptr("none,ddl,mod,all"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("none"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("none"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_locks_per_transaction"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/max_locks_per_transaction"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of locks per transaction."),
		// 				AllowedValues: to.Ptr("10-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_pred_locks_per_transaction"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/max_pred_locks_per_transaction"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of predicate locks per transaction."),
		// 				AllowedValues: to.Ptr("10-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_prepared_transactions"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/max_prepared_transactions"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of simultaneously prepared transactions."),
		// 				AllowedValues: to.Ptr("0-8388607"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("quote_all_identifiers"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/quote_all_identifiers"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("When generating SQL fragments, quote all identifiers."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("random_page_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/random_page_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of a nonsequentially fetched disk page."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("4.0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("4.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("search_path"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/search_path"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the schema search order for names that are not schema-qualified."),
		// 				AllowedValues: to.Ptr("[A-Za-z.\"$, ]+"),
		// 				DataType: to.Ptr("String"),
		// 				DefaultValue: to.Ptr("\"$user\", public"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("\"$user\", public"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("seq_page_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/seq_page_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of a sequentially fetched disk page."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("1.0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sql_inheritance"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/sql_inheritance"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Causes subtables to be included by default in various commands."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standard_conforming_strings"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/standard_conforming_strings"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Causes '...' strings to treat backslashes literally."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("statement_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/statement_timeout"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration (in milliseconds) of any statement. 0 turns this off."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synchronize_seqscans"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/synchronize_seqscans"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Enable synchronized sequential scans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synchronous_commit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/synchronous_commit"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the current transaction's synchronization level."),
		// 				AllowedValues: to.Ptr("local,remote_write,on,off"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("transform_null_equals"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/transform_null_equals"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Treats \"expr=NULL\" as \"expr IS NULL\"."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr("Boolean"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("xmlbinary"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/xmlbinary"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets how binary values are to be encoded in XML."),
		// 				AllowedValues: to.Ptr("base64,hex"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("base64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("base64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("xmloption"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/xmloption"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets whether XML data in implicit parsing and serialization operations is to be considered as documents or content fragments."),
		// 				AllowedValues: to.Ptr("content,document"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("content"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("content"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("force_parallel_mode"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/force_parallel_mode"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Forces use of parallel query facilities."),
		// 				AllowedValues: to.Ptr("off,on,regress"),
		// 				DataType: to.Ptr("Enumeration"),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("idle_in_transaction_session_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/idle_in_transaction_session_timeout"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration of any idling transaction."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_parallel_workers_per_gather"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/max_parallel_workers_per_gather"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of parallel processes per executor node."),
		// 				AllowedValues: to.Ptr("0-1024"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("min_parallel_relation_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/min_parallel_relation_size"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum size of relations to be considered for parallel scan."),
		// 				AllowedValues: to.Ptr("0-715827882"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("8388608"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8388608"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("parallel_setup_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/parallel_setup_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of starting up worker processes for parallel query."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("1000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("parallel_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/parallel_tuple_cost"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of passing each tuple (row) from worker to master backend."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr("Numeric"),
		// 				DefaultValue: to.Ptr("0.1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_retention_days"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/servers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/servers/testserver/configurations/log_retention_days"),
		// 			Properties: &armpostgresql.ConfigurationProperties{
		// 				Description: to.Ptr("Sets how many days a log file is saved for."),
		// 				AllowedValues: to.Ptr("1-7"),
		// 				DataType: to.Ptr("Integer"),
		// 				DefaultValue: to.Ptr("3"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("3"),
		// 			},
		// 	}},
		// }
	}
}
