//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TimeZonesServer is a fake server for instances of the armsql.TimeZonesClient type.
type TimeZonesServer struct {
	// Get is the fake for method TimeZonesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, locationName string, timeZoneID string, options *armsql.TimeZonesClientGetOptions) (resp azfake.Responder[armsql.TimeZonesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByLocationPager is the fake for method TimeZonesClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(locationName string, options *armsql.TimeZonesClientListByLocationOptions) (resp azfake.PagerResponder[armsql.TimeZonesClientListByLocationResponse])
}

// NewTimeZonesServerTransport creates a new instance of TimeZonesServerTransport with the provided implementation.
// The returned TimeZonesServerTransport instance is connected to an instance of armsql.TimeZonesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTimeZonesServerTransport(srv *TimeZonesServer) *TimeZonesServerTransport {
	return &TimeZonesServerTransport{
		srv:                    srv,
		newListByLocationPager: newTracker[azfake.PagerResponder[armsql.TimeZonesClientListByLocationResponse]](),
	}
}

// TimeZonesServerTransport connects instances of armsql.TimeZonesClient to instances of TimeZonesServer.
// Don't use this type directly, use NewTimeZonesServerTransport instead.
type TimeZonesServerTransport struct {
	srv                    *TimeZonesServer
	newListByLocationPager *tracker[azfake.PagerResponder[armsql.TimeZonesClientListByLocationResponse]]
}

// Do implements the policy.Transporter interface for TimeZonesServerTransport.
func (t *TimeZonesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TimeZonesClient.Get":
		resp, err = t.dispatchGet(req)
	case "TimeZonesClient.NewListByLocationPager":
		resp, err = t.dispatchNewListByLocationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TimeZonesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/timeZones/(?P<timeZoneId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	timeZoneIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("timeZoneId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), locationNameParam, timeZoneIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TimeZone, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TimeZonesServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := t.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/timeZones`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByLocationPager(locationNameParam, nil)
		newListByLocationPager = &resp
		t.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armsql.TimeZonesClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		t.newListByLocationPager.remove(req)
	}
	return resp, nil
}
