/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableSetMultimapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testBuilderOrderKeysAndValuesBy() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderOrderKeysAndValuesBy();
}

public void testBuilderOrderKeysBy() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderOrderKeysBy();
}

public void testBuilderOrderKeysByDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderOrderKeysByDuplicates();
}

public void testBuilderOrderValuesBy() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderOrderValuesBy();
}

public void testBuilderPutAllIterable() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutAllIterable();
}

public void testBuilderPutAllMultimap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutAllMultimap();
}

public void testBuilderPutAllMultimapWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutAllMultimapWithDuplicates();
}

public void testBuilderPutAllVarargs() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutAllVarargs();
}

public void testBuilderPutAllWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutAllWithDuplicates();
}

public void testBuilderPutNullKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutNullKey();
}

public void testBuilderPutNullValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutNullValue();
}

public void testBuilderPutWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilderPutWithDuplicates();
}

public void testBuilder_withImmutableEntry() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilder_withImmutableEntry();
}

public void testBuilder_withImmutableEntryAndNullContents() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilder_withImmutableEntryAndNullContents();
}

public void testBuilder_withMutableEntry() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testBuilder_withMutableEntry();
}

public void testCopyOf() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOf();
}

public void testCopyOfEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOfEmpty();
}

public void testCopyOfImmutableSetMultimap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOfImmutableSetMultimap();
}

public void testCopyOfNullKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOfNullKey();
}

public void testCopyOfNullValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOfNullValue();
}

public void testCopyOfWithDuplicates() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testCopyOfWithDuplicates();
}

public void testEmptyMultimapReads() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testEmptyMultimapReads();
}

public void testEmptyMultimapWrites() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testEmptyMultimapWrites();
}

public void testFlatteningToImmutableSetMultimap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testFlatteningToImmutableSetMultimap();
}

public void testInverse() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testInverse();
}

public void testInverseMinimizesWork() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testInverseMinimizesWork();
}

public void testMultimapEquals() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testMultimapEquals();
}

public void testMultimapReads() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testMultimapReads();
}

public void testMultimapWrites() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testMultimapWrites();
}

public void testOf() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testOf();
}

public void testToImmutableSetMultimap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapTest testCase = new com.google.common.collect.ImmutableSetMultimapTest();
  testCase.testToImmutableSetMultimap();
}
}
