; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -verify -iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test looks at the constants in the regions, and if it they are the
; differents it elevates the constants to arguments.

define void @outline_constants1() {
; CHECK-LABEL: @outline_constants1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 3, i32* [[A]], i32 4, i32* [[B]], i32 5, i32* [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 3, i32* %a, align 4
  store i32 4, i32* %b, align 4
  store i32 5, i32* %c, align 4
  %al = load i32, i32* %a
  %bl = load i32, i32* %b
  %cl = load i32, i32* %c
  ret void
}

define void @outline_constants2() {
; CHECK-LABEL: @outline_constants2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @outlined_ir_func_0(i32 2, i32* [[A]], i32 3, i32* [[B]], i32 4, i32* [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, i32* %a, align 4
  store i32 3, i32* %b, align 4
  store i32 4, i32* %c, align 4
  %al = load i32, i32* %a
  %bl = load i32, i32* %b
  %cl = load i32, i32* %c
  ret void
}

; CHECK: define internal void @outlined_ir_func_0(i32 [[ARG0:%.*]], i32* [[ARG1:%.*]], i32 [[ARG2:%.*]], i32* [[ARG3:%.*]], i32 [[ARG4:%.*]], i32* [[ARG5:%.*]]) #0 {
; CHECK: entry_to_outline:
; CHECK-NEXT:    store i32 [[ARG0]], i32* [[ARG1]], align 4
; CHECK-NEXT:    store i32 [[ARG2]], i32* [[ARG3]], align 4
; CHECK-NEXT:    store i32 [[ARG4]], i32* [[ARG5]], align 4
; CHECK-NEXT:    [[AL:%.*]] = load i32, i32* [[ARG1]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, i32* [[ARG3]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, i32* [[ARG5]], align 4
