; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; Fold
;   x s/EXACT (-1 << y)
; to
;   -(x a>>EXACT y)

define i8 @t0(i8 %x) {
; CHECK-LABEL: @t0(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = ashr exact i8 [[X:%.*]], 5
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw i8 0, [[DIV_NEG]]
; CHECK-NEXT:    ret i8 [[DIV]]
;
  %div = sdiv exact i8 %x, -32
  ret i8 %div
}

define i8 @n1(i8 %x) {
; CHECK-LABEL: @n1(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i8 [[X:%.*]], -32
; CHECK-NEXT:    ret i8 [[DIV]]
;
  %div = sdiv i8 %x, -32 ; not exact
  ret i8 %div
}

define <2 x i8> @t2_vec_splat(<2 x i8> %x) {
; CHECK-LABEL: @t2_vec_splat(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = ashr exact <2 x i8> [[X:%.*]], <i8 5, i8 5>
; CHECK-NEXT:    [[DIV:%.*]] = sub nsw <2 x i8> zeroinitializer, [[DIV_NEG]]
; CHECK-NEXT:    ret <2 x i8> [[DIV]]
;
  %div = sdiv exact <2 x i8> %x, <i8 -32, i8 -32>
  ret <2 x i8> %div
}

define <2 x i8> @t3_vec(<2 x i8> %x) {
; CHECK-LABEL: @t3_vec(
; CHECK-NEXT:    [[DIV_NEG:%.*]] = ashr exact <2 x i8> [[X:%.*]], <i8 5, i8 4>
; CHECK-NEXT:    [[DIV:%.*]] = sub <2 x i8> zeroinitializer, [[DIV_NEG]]
; CHECK-NEXT:    ret <2 x i8> [[DIV]]
;
  %div = sdiv exact <2 x i8> %x, <i8 -32, i8 -16>
  ret <2 x i8> %div
}

define <2 x i8> @n4_vec_mixed(<2 x i8> %x) {
; CHECK-LABEL: @n4_vec_mixed(
; CHECK-NEXT:    [[DIV:%.*]] = sdiv exact <2 x i8> [[X:%.*]], <i8 -32, i8 16>
; CHECK-NEXT:    ret <2 x i8> [[DIV]]
;
  %div = sdiv exact <2 x i8> %x, <i8 -32, i8 16>
  ret <2 x i8> %div
}

define <2 x i8> @n4_vec_undef(<2 x i8> %x) {
; CHECK-LABEL: @n4_vec_undef(
; CHECK-NEXT:    ret <2 x i8> poison
;
  %div = sdiv exact <2 x i8> %x, <i8 -32, i8 undef>
  ret <2 x i8> %div
}

define i8 @prove_exact_with_high_mask(i8 %x, i8 %y) {
; CHECK-LABEL: @prove_exact_with_high_mask(
; CHECK-NEXT:    [[A:%.*]] = ashr i8 [[X:%.*]], 2
; CHECK-NEXT:    [[D_NEG:%.*]] = and i8 [[A]], -8
; CHECK-NEXT:    [[D:%.*]] = sub nsw i8 0, [[D_NEG]]
; CHECK-NEXT:    ret i8 [[D]]
;
  %a = and i8 %x, -32
  %d = sdiv i8 %a, -4
  ret i8 %d
}

define i8 @prove_exact_with_high_mask_limit(i8 %x, i8 %y) {
; CHECK-LABEL: @prove_exact_with_high_mask_limit(
; CHECK-NEXT:    [[A:%.*]] = ashr i8 [[X:%.*]], 5
; CHECK-NEXT:    [[D:%.*]] = sub nsw i8 0, [[A]]
; CHECK-NEXT:    ret i8 [[D]]
;
  %a = and i8 %x, -32
  %d = sdiv i8 %a, -32
  ret i8 %d
}

; negative test - not enough low zeros in dividend

define i8 @not_prove_exact_with_high_mask(i8 %x, i8 %y) {
; CHECK-LABEL: @not_prove_exact_with_high_mask(
; CHECK-NEXT:    [[A:%.*]] = and i8 [[X:%.*]], -32
; CHECK-NEXT:    [[D:%.*]] = sdiv i8 [[A]], -64
; CHECK-NEXT:    ret i8 [[D]]
;
  %a = and i8 %x, -32
  %d = sdiv i8 %a, -64
  ret i8 %d
}

define <2 x i8> @prove_exact_with_high_mask_splat_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @prove_exact_with_high_mask_splat_vec(
; CHECK-NEXT:    [[A:%.*]] = shl <2 x i8> [[X:%.*]], <i8 5, i8 5>
; CHECK-NEXT:    [[D_NEG:%.*]] = ashr exact <2 x i8> [[A]], <i8 4, i8 4>
; CHECK-NEXT:    [[D:%.*]] = sub nsw <2 x i8> zeroinitializer, [[D_NEG]]
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %a = shl <2 x i8> %x, <i8 5, i8 5>
  %d = sdiv <2 x i8> %a, <i8 -16, i8 -16>
  ret <2 x i8> %d
}

; TODO: Needs knownbits to handle arbitrary vector constants.

define <2 x i8> @prove_exact_with_high_mask_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @prove_exact_with_high_mask_vec(
; CHECK-NEXT:    [[A:%.*]] = shl <2 x i8> [[X:%.*]], <i8 3, i8 2>
; CHECK-NEXT:    [[D:%.*]] = sdiv <2 x i8> [[A]], <i8 -8, i8 -4>
; CHECK-NEXT:    ret <2 x i8> [[D]]
;
  %a = shl <2 x i8> %x, <i8 3, i8 2>
  %d = sdiv <2 x i8> %a, <i8 -8, i8 -4>
  ret <2 x i8> %d
}
