/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public final class JMessage
extends JDialog {
    private static final String ERROR_TITLE = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("errorTitle");
    private static final String INFO_TITLE = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("infoTitle");
    private static final String WARNING_TITLE = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("warningTitle");
    private static final String QUESTION_TITLE = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("questionTitle");
    private static final String PLAIN_TITLE = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("plainTitle");
    private static final String OK_BUTTON_TEXT = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("okButtonText");
    private static final String CANCEL_BUTTON_TEXT = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("cancelButtonText");
    private static final String YES_BUTTON_TEXT = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("yesButtonText");
    private static final String NO_BUTTON_TEXT = ResourceBundle.getBundle("gr/zeus/res/jmessage").getString("noButtonText");
    private static final ImageIcon EXPAND_ICON = new ImageIcon(JMessage.class.getResource("/gr/zeus/res/expand.gif"));
    private static final ImageIcon COLLAPSE_ICON = new ImageIcon(JMessage.class.getResource("/gr/zeus/res/collapse.gif"));
    private static final int MIN_COLUMNS = 50;
    private static final int NUM_ROWS = 15;
    private JMessageButtonEnum m_defaultButton = JMessageButtonEnum.OK;
    private int m_returnStatus = -1;
    private JPanel m_buttonsPane;
    private JButton m_cancelButton;
    private JPanel m_centerPane;
    private JToggleButton m_detailsButton;
    private JPanel m_eastPane;
    private JLabel m_emptySpace;
    private JLabel m_icon;
    private JTextArea m_messageException;
    private JPanel m_messagePane;
    private JLabel m_messageText;
    private JButton m_noButton;
    private JButton m_okButton;
    private JScrollPane m_scrollPane;
    private JPanel m_westPane;
    private JButton m_yesButton;

    public static boolean showErrorQuestionMessageY(Frame parent, String message, Throwable ex) {
        int messageType = 0;
        JMessage msg = new JMessage(parent, message, null, messageType, 0, JMessageButtonEnum.YES, JMessage.get_default_ico(messageType), ex, null, null, null, null);
        msg.setVisible(true);
        return msg.getReturnStatus() == 0;
    }

    public static void showErrorMessage(Frame parent, String message) {
        JMessage.showErrorMessage(parent, message, null);
    }

    public static void showErrorMessage(Frame parent, String message, Throwable ex) {
        JMessage.showMessageDialog(parent, message, 0, -1, ex);
    }

    public static void showWarningMessage(Frame parent, String message) {
        JMessage.showWarningMessage(parent, message, null);
    }

    public static void showWarningMessage(Frame parent, String message, Throwable ex) {
        JMessage.showMessageDialog(parent, message, 2, -1, ex);
    }

    public static void showInfoMessage(Frame parent, String message) {
        JMessage.showInfoMessage(parent, message, null);
    }

    public static void showInfoMessage(Frame parent, String message, Throwable ex) {
        JMessage.showMessageDialog(parent, message, 1, -1, ex);
    }

    public static boolean showQuestionMessageN(Frame parent, String message) {
        int res = JMessage.showMessageDialog(parent, message, 3, 0, JMessageButtonEnum.NO);
        return res == 0;
    }

    public static boolean showQuestionMessageY(Frame parent, String message) {
        int res = JMessage.showMessageDialog(parent, message, 3, 0, JMessageButtonEnum.YES);
        return res == 0;
    }

    public static int showMessageDialog(Frame parent, String message, int messageType, int optionType) {
        JMessage msg = new JMessage(parent, message, null, messageType, optionType, null, JMessage.get_default_ico(messageType), null, null, null, null, null);
        msg.setVisible(true);
        return msg.getReturnStatus();
    }

    public static int showMessageDialog(Frame parent, String message, int messageType, int optionType, JMessageButtonEnum defaultButton) {
        JMessage msg = new JMessage(parent, message, null, messageType, optionType, defaultButton, JMessage.get_default_ico(messageType), null, null, null, null, null);
        msg.setVisible(true);
        return msg.getReturnStatus();
    }

    public static int showMessageDialog(Frame parent, String message, int messageType, int optionType, Throwable ex) {
        JMessage msg = new JMessage(parent, message, null, messageType, optionType, null, JMessage.get_default_ico(messageType), ex, null, null, null, null);
        msg.setVisible(true);
        return msg.getReturnStatus();
    }

    public static int showMessageDialog(Frame parent, String message, String frameTitle, int messageType, int optionType, JMessageButtonEnum defaultButton, Icon ico, Throwable ex, String okText, String cancelText, String yesText, String noText) {
        JMessage msg = new JMessage(parent, message, frameTitle, messageType, optionType, defaultButton, ico, ex, okText, cancelText, yesText, noText);
        msg.setVisible(true);
        return msg.getReturnStatus();
    }

    public JMessage(Frame parent, String message, String frameTitle, int messageType, int optionType, JMessageButtonEnum defaultButton, Icon ico, Throwable ex, String okText, String cancelText, String yesText, String noText) {
        super(parent, frameTitle != null ? frameTitle : JMessage.get_localized_title(messageType), true);
        boolean hasException;
        boolean supportsWindowDecorations;
        this.m_defaultButton = defaultButton;
        if (this.m_defaultButton == null) {
            this.m_defaultButton = JMessage.get_default_button(optionType);
        }
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(JMessage.styleFromMessageType(messageType));
        }
        this.initComponents();
        this.m_centerPane.remove(this.m_scrollPane);
        this.m_icon.setIcon(ico);
        this.setup_buttons(optionType, okText, cancelText, yesText, noText);
        this.m_messageText.setText(JMessage.convert_message_to_html(message));
        boolean bl = hasException = ex != null;
        if (hasException) {
            this.m_messageException.setColumns(50);
            this.m_messageException.setRows(15);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.m_messageException.setText(sw.toString());
            this.m_messageException.setCaretPosition(0);
        }
        this.m_detailsButton.setVisible(hasException);
        this.m_emptySpace.setMinimumSize(this.m_icon.getPreferredSize());
        this.m_emptySpace.setMaximumSize(this.m_icon.getPreferredSize());
        this.m_emptySpace.setPreferredSize(this.m_icon.getPreferredSize());
        this.pack();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    private void initComponents() {
        this.m_westPane = new JPanel();
        this.m_icon = new JLabel();
        this.m_centerPane = new JPanel();
        this.m_messagePane = new JPanel();
        this.m_messageText = new JLabel();
        this.m_detailsButton = new JToggleButton();
        this.m_scrollPane = new JScrollPane();
        this.m_messageException = new JTextArea();
        this.m_buttonsPane = new JPanel();
        this.m_okButton = new JButton();
        this.m_yesButton = new JButton();
        this.m_noButton = new JButton();
        this.m_cancelButton = new JButton();
        this.m_eastPane = new JPanel();
        this.m_emptySpace = new JLabel();
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JMessage.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                JMessage.this.formWindowOpened(evt);
            }
        });
        this.m_westPane.setLayout(new FlowLayout(1, 10, 10));
        this.m_westPane.add(this.m_icon);
        this.getContentPane().add((Component)this.m_westPane, "West");
        this.m_centerPane.setLayout(new BorderLayout());
        this.m_messagePane.setLayout(new FlowLayout(0, 5, 20));
        this.m_messagePane.add(this.m_messageText);
        this.m_detailsButton.setIcon(new ImageIcon(this.getClass().getResource("/gr/zeus/res/expand.gif")));
        this.m_detailsButton.setFocusPainted(false);
        this.m_detailsButton.setMaximumSize(new Dimension(18, 18));
        this.m_detailsButton.setMinimumSize(new Dimension(18, 18));
        this.m_detailsButton.setPreferredSize(new Dimension(18, 18));
        this.m_detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessage.this.m_detailsButtonActionPerformed(evt);
            }
        });
        this.m_messagePane.add(this.m_detailsButton);
        this.m_centerPane.add((Component)this.m_messagePane, "North");
        this.m_messageException.setEditable(false);
        this.m_scrollPane.setViewportView(this.m_messageException);
        this.m_centerPane.add((Component)this.m_scrollPane, "Center");
        this.m_buttonsPane.setLayout(new FlowLayout(1, 5, 10));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessage.this.m_okButtonActionPerformed(evt);
            }
        });
        this.m_buttonsPane.add(this.m_okButton);
        this.m_yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessage.this.m_yesButtonActionPerformed(evt);
            }
        });
        this.m_buttonsPane.add(this.m_yesButton);
        this.m_noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessage.this.m_noButtonActionPerformed(evt);
            }
        });
        this.m_buttonsPane.add(this.m_noButton);
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMessage.this.m_cancelButtonActionPerformed(evt);
            }
        });
        this.m_buttonsPane.add(this.m_cancelButton);
        this.m_centerPane.add((Component)this.m_buttonsPane, "South");
        this.getContentPane().add((Component)this.m_centerPane, "Center");
        this.m_eastPane.setLayout(new FlowLayout(1, 10, 10));
        this.m_eastPane.add(this.m_emptySpace);
        this.getContentPane().add((Component)this.m_eastPane, "East");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        JButton tmp;
        if (this.m_defaultButton != null && (tmp = this.m_defaultButton.whichOne(this.m_okButton, this.m_cancelButton, this.m_yesButton, this.m_noButton)).isVisible()) {
            this.getRootPane().setDefaultButton(tmp);
            tmp.requestFocus();
        }
    }

    private void m_cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void m_noButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void m_yesButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void m_okButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose(-1);
    }

    private void m_detailsButtonActionPerformed(ActionEvent evt) {
        if (!this.m_detailsButton.isSelected()) {
            this.m_detailsButton.setIcon(EXPAND_ICON);
            this.m_centerPane.remove(this.m_scrollPane);
        } else {
            this.m_detailsButton.setIcon(COLLAPSE_ICON);
            this.m_centerPane.add((Component)this.m_scrollPane, "Center");
        }
        this.pack();
    }

    private void doClose(int retStatus) {
        this.m_returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private static final String get_localized_title(int messageType) {
        switch (messageType) {
            case 0: {
                return ERROR_TITLE;
            }
            case 1: {
                return INFO_TITLE;
            }
            case 2: {
                return WARNING_TITLE;
            }
            case 3: {
                return QUESTION_TITLE;
            }
        }
        return PLAIN_TITLE;
    }

    private static final Icon get_default_ico(int messageType) {
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    private void setup_buttons(int optionType, String okText, String cancelText, String yesText, String noText) {
        this.m_okButton.setText(okText != null ? okText : OK_BUTTON_TEXT);
        this.m_cancelButton.setText(cancelText != null ? cancelText : CANCEL_BUTTON_TEXT);
        this.m_yesButton.setText(yesText != null ? yesText : YES_BUTTON_TEXT);
        this.m_noButton.setText(noText != null ? noText : NO_BUTTON_TEXT);
        switch (optionType) {
            case 1: {
                this.m_okButton.setVisible(false);
                this.m_cancelButton.setVisible(true);
                this.m_yesButton.setVisible(true);
                this.m_noButton.setVisible(true);
                break;
            }
            case 0: {
                this.m_okButton.setVisible(false);
                this.m_cancelButton.setVisible(false);
                this.m_yesButton.setVisible(true);
                this.m_noButton.setVisible(true);
                break;
            }
            case 2: {
                this.m_okButton.setVisible(true);
                this.m_cancelButton.setVisible(true);
                this.m_yesButton.setVisible(false);
                this.m_noButton.setVisible(false);
                break;
            }
            default: {
                this.m_okButton.setVisible(true);
                this.m_cancelButton.setVisible(false);
                this.m_yesButton.setVisible(false);
                this.m_noButton.setVisible(false);
            }
        }
    }

    private static String convert_message_to_html(String message) {
        String htmlMessage = message != null ? message : "";
        if (!(htmlMessage = htmlMessage.trim()).startsWith("<html>")) {
            htmlMessage = "<html>" + htmlMessage;
        }
        if (!htmlMessage.endsWith("</html>")) {
            htmlMessage = htmlMessage + "</html>";
        }
        htmlMessage = htmlMessage.replaceAll("\n", "<br>");
        return htmlMessage;
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    private static JMessageButtonEnum get_default_button(int optionType) {
        switch (optionType) {
            case 0: 
            case 1: {
                return JMessageButtonEnum.YES;
            }
        }
        return JMessageButtonEnum.OK;
    }

    public static enum JMessageButtonEnum {
        OK,
        CANCEL,
        YES,
        NO;


        JButton whichOne(JButton btn_ok, JButton btn_cancel, JButton btn_yes, JButton btn_no) {
            switch (this) {
                case OK: {
                    return btn_ok;
                }
                case CANCEL: {
                    return btn_cancel;
                }
                case YES: {
                    return btn_yes;
                }
                case NO: {
                    return btn_no;
                }
            }
            throw new AssertionError((Object)("Unknown JMessageButtonEnum: " + (Object)((Object)this)));
        }
    }
}

