/* $Id: Score.hpp 199287 2010-08-02 16:36:25Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Score.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Score_.hpp


#ifndef OBJECTS_SEQALIGN_SCORE_HPP
#define OBJECTS_SEQALIGN_SCORE_HPP


// generated includes
#include <objects/seqalign/Score_.hpp>

// generated classes


#include <objects/general/Object_id.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CScore : public CScore_Base
{
    typedef CScore_Base Tparent;
public:
    // constructor
    CScore(void);
    // destructor
    ~CScore(void);

private:
    // Prohibit copy constructor and assignment operator
    CScore(const CScore& value);
    CScore& operator=(const CScore& value);

};

/////////////////// CScore inline methods

// constructor
inline
CScore::CScore(void)
{
}


/////////////////// end of CScore inline methods


/////////////////////////////////////////////////////////////////////////////
// CReadSharedScoreIdHook
//   read hooks for shared score.id objects.
/////////////////////////////////////////////////////////////////////////////


class NCBI_SEQALIGN_EXPORT CReadSharedScoreIdHook :
    public CReadSharedObjectIdHookBase
{
public:
    void ReadClassMember(CObjectIStream& in, const CObjectInfoMI& member);

    static void SetHook(CObjectIStream& in);
    static void SetGlobalHook(void);

private:
    static CObjectTypeInfoMI x_GetMember(void);
};


/////////////////////////////////////////////////////////////////////////////


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SCORE_HPP
/* Original file checksum: lines: 86, chars: 2346, CRC32: adbeb09a */
