
; Create BASIC line from directory entry


; in:  .X = offset from XX_DIRENT_BUF, .Y = characters to indent after line number
; out: .X (low byte) = current position, .A = 0


util_dir_basic:

	lda #$01                           ; link to the next line - dummy, will be regenerated by BASIC
	sta XX_DIRENT_BUF, x
	inx
	sta XX_DIRENT_BUF, x
	inx

	lda PAR_FSIZE_BLOCKS+0             ; store number of blocks
	sta XX_DIRENT_BUF, x
	inx
	lda PAR_FSIZE_BLOCKS+1
	sta XX_DIRENT_BUF, x
	inx

	lda #' '                           ; indent file name

@lp1:
	dey
	bmi @lp1_done
	sta XX_DIRENT_BUF, x
	inx
	bra @lp1

@lp1_done:

	lda #$22                           ; opening quote
	sta XX_DIRENT_BUF, x
	inx

	ldy #$FF                           ; put file name

@lp2:

	iny
	lda PAR_FNAME, y
	cmp #$A0
	beq @lp2_done
	cpy #$10
	beq @lp2_done
	sta XX_DIRENT_BUF, x
	inx
	bra @lp2

@lp2_done:

	lda #$22                           ; closing quote
	sta XX_DIRENT_BUF, x
	inx

	ldy #$10                           ; put spaces for indentation

@lp3:

	dey
	lda PAR_FNAME, y
	cmp #$A0
	bne @lp3_done

	lda #' '
	sta XX_DIRENT_BUF, x
	inx
	bra @lp3

@lp3_done:

	lda PAR_FTYPE                      ; put 'damaged' mark if needed
	bmi @closed
	lda #'*'
	+skip_2_bytes_trash_nvz

@closed:

	lda #' '
	sta XX_DIRENT_BUF, x
	inx

	lda PAR_FTYPE                      ; put file type
	and #$3F
	asl
	asl
	tay

@lp4:
	
	lda dir_types, y
	beq @lp4_done
	sta XX_DIRENT_BUF, x
	inx
	iny
	bra @lp4
	
@lp4_done:

	lda PAR_FTYPE                      ; read-only mark (if needed)
	and #$40
	beq @skipro
	lda #'<'
	sta XX_DIRENT_BUF, x
	inx

@skipro:

	lda #$00                           ; put end of the line
	sta XX_DIRENT_BUF, x
	inx
	
	rts
