# == Class: vmms::params
#
# Parameters for puppet-vmms
#
class vmms::params {
  include openstacklib::defaults

  $client_package      = 'python3-vmmsclient'
  $db_sync_command     = 'vmms-manage db_sync'
  $user                = 'vmms'
  $group               = 'vmms'

  case $facts['os']['family'] {
    'Debian': {
      $common_package_name        = 'vmms-common'
      $api_package_name           = 'vmms-api'
      $api_service_name           = 'vmms-api'
      $worker_package_name        = 'vmms-worker'
      $worker_service_name        = 'vmms-worker'
    }
    default: {
      fail("Unsupported osfamily: ${facts['os']['family']}")
    }
  }
}
