% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dbs_context.R
\name{get_dbs_context}
\alias{get_dbs_context}
\title{Get DBS context}
\usage{
get_dbs_context(vcf_list)
}
\arguments{
\item{vcf_list}{GRanges/GRangesList}
}
\value{
A version of the GRanges/GRangesList object, with modified REF and ALT columns.
}
\description{
Get the DBS COSMIC context on an GRanges/GRangesList object.
It applies the get_dbs_context_gr function to each gr in the input,
which works by changing the REF and ALT columns of the GRanges into the COSMIC types.
}
\examples{
## Get GRangesList with DBS.
## See 'get_mut_type' or 'read_vcfs_as_granges' for more info on how to do this.
dbs_grl <- readRDS(system.file("states/blood_grl_dbs.rds",
  package = "MutationalPatterns"
))

## Set context dbs
get_dbs_context(dbs_grl)
}
\seealso{
\code{\link{get_mut_type}}, \code{\link{read_vcfs_as_granges}}

Other DBS: 
\code{\link{count_dbs_contexts}()},
\code{\link{plot_compare_dbs}()},
\code{\link{plot_dbs_contexts}()},
\code{\link{plot_main_dbs_contexts}()}
}
\concept{DBS}
