% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_docx}
\alias{body_add_docx}
\title{Add an external docx in a 'Word' document}
\usage{
body_add_docx(x, src, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{src}{docx filename, the path of the file must not contain
any '&' and the basename must not contain any space.}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
Add content of a docx into an rdocx object.

The function is using a 'Microsoft Word' feature: when the
document will be edited, the content of the file will be
inserted in the main document.

This feature is unlikely to work as expected if the
resulting document is edited by another software. You
can use function \code{\link[=body_import_docx]{body_import_docx()}} to import the content
as an alternative.

The file is added when the method \code{print()} that
produces the final Word file is called, so don't remove
file defined with \code{src} before.
}
\examples{
file1 <- tempfile(fileext = ".docx")
file2 <- tempfile(fileext = ".docx")
file3 <- tempfile(fileext = ".docx")
x <- read_docx()
x <- body_add_par(x, "hello world 1", style = "Normal")
print(x, target = file1)

x <- read_docx()
x <- body_add_par(x, "hello world 2", style = "Normal")
print(x, target = file2)

x <- read_docx(path = file1)
x <- body_add_break(x)
x <- body_add_docx(x, src = file2)
print(x, target = file3)
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()},
\code{\link{body_append_start_context}()},
\code{\link{body_import_docx}()}
}
\concept{functions for adding content}
