% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_records_rank.R
\name{wm_records_rank}
\alias{wm_records_rank}
\title{Get AphiaRecords for a given taxonRankID}
\usage{
wm_records_rank(rank_id, id = NULL, offset = 1, ...)
}
\arguments{
\item{rank_id}{(numeric/integer) a rank id}

\item{id}{(character) a single AphiaID}

\item{offset}{(integer) record to start at. default: 1}

\item{...}{named curl options. see \code{curl::curl_options}}
}
\value{
A tibble/data.frame. when using underscore method, outputs from
each input are binded together, but can be split by \code{id} column
}
\description{
Get AphiaRecords for a given taxonRankID
}
\section{Singular vs. plural}{

Of the two sister functions, the one without the underscore is the original
function that wraps the relavant WoRMS API method - and only accepts
one thing (i.e., name or AphiaID) per request.

The sister function with the underscore at the end is the plural version,
accepting more than one input. Internally this function loops over
the non-underscore method, and labels output (whether it's a list or
data.frame rows) with the input names or IDs so that you can easily
parse output by your inputs.
}

\examples{
\dontrun{
wm_records_rank(rank_id = 180, id = 106776)
wm_records_rank(rank_id = 180, id = 106776, offset = 50)
}
}
