RabbitMQ `3.8.31` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a `3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * Cleaned up some compiler options that are no longer relevant.

   Contributed by Péter @gomoripeti Gömöri (CloudAMQP).

   GitHub issue: [#4707](https://github.com/rabbitmq/rabbitmq-server/pull/4707)


### JMS Topic Exchange Plugin

#### Bug Fixes

 * "In flight" messages directed to an exchange that has just been deleted will be
   silently dropped or [returned back to the publisher](https://rabbitmq.com/publishers.html#unroutable) instead of causing an exception.

   GitHub issue: [#4696](https://github.com/rabbitmq/rabbitmq-server/pull/4696)


## Dependency Upgrades

 * `credentials_obfuscation` was upgraded [from v2.4.0 to v3.0.0](https://github.com/rabbitmq/credentials-obfuscation/compare/v2.4.0...v3.0.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.31.tar.xz`
instead of the source tarball produced by GitHub.

