// re2js $INPUT -o $OUTPUT

const assert = require('assert');

function parse(yyinput) {
    let yycursor = 0

    // Final tag variables available in semantic action.
    /*!svars:re2c format = "let @@\n"; */

    // Intermediate tag variables used by the lexer (must be autogenerated).
    /*!stags:re2c format = "let @@\n"; */

    /*!re2c
        re2c:yyfill:enable = 0;
        re2c:tags = 1;

        num = [0-9]+;

        @t1 num @t2 "." @t3 num @t4 ("." @t5 num)? [\x00] {
            return {
                major: Number(yyinput.substring(t1, t2)),
                minor: Number(yyinput.substring(t3, t4)),
                patch: t5 == -1 ? 0 : Number(yyinput.substring(t5, yycursor - 1))
            }
        }
        * { return null }
    */
}

assert.deepEqual(parse("23.34\0"), {major: 23, minor: 34, patch: 0})
assert.deepEqual(parse("1.2.99999\0"), {major: 1, minor: 2, patch: 99999})
assert.deepEqual(parse("1.a\0"), null)
