---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, alignement de paragraphes, 
              indentation
---

# Comment aligner des paragraphes ?

## Avec l'extension <ctanpkg:hanging>

L'extension <ctanpkg:hanging>, de Peter Wilson, offre la solution 
la plus générale. Elle propose en effet un environnement `hangparas` doté 
de deux arguments :
- l'indentation (une longueur) ;
- un nombre précisant les lignes à indenter :
  - si ce nombre est positif, il indique le nombre de premières lignes 
  du paragraphe qui ne sont pas indentées,
  - s'il est négatif, il indique le nombre de premières lignes 
  du paragraphe qui sont indentées.

L'exemple suivant illustre les deux situations.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{hanging}

\begin{document}
Les deux paragraphes suivants, reprenant une citation d'Ambrose Bierce, 
illustre le fonctionnement de l'extension \textsf{hanging}.
\vspace{0.5cm}

\begin{hangparas}{2cm}{2}
Australie : pays situé dans les mers du Sud, dont le développement 
industriel et commercial a été épouvantablement retardé par une 
fâcheuse querelle entre les géographes sur la question de savoir 
s'il s'agissait d'une île ou d'un continent.
\end{hangparas}
\vspace{0.5cm}

\begin{hangparas}{1cm}{-3}
Australie : pays situé dans les mers du Sud, dont le développement 
industriel et commercial a été épouvantablement retardé par une 
fâcheuse querelle entre les géographes sur la question de savoir 
s'il s'agissait d'une île ou d'un continent.
\end{hangparas}
\end{document}
```

Cette extension propose également une commande `\hangparas` 
(avec les mêmes arguments que l'environnement `hangparas`) 
pour traiter un unique paragraphe.


## Avec la commande `\parindent`

La commande `\parindent` peut être ici utilisée de manière complètement 
détournée. L'exemple suivant définit cette longueur comme identique 
à celle de l'expression "Notes :" par le biais de la commande 
`\settowidth`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \settowidth{\parindent}{Notes : }

\begin{document}
\makebox[0pt][r]{Notes : }Cette note est pertinente.

Je dirai même plus : cette note n'apporte rien de remarquable.

Pas mieux !

\vspace{1cm}
\emph{Le lecteur averti pourra noter que des phrases bien plus longues 
cassent quelque peu cette logique d'alignement car seule la première 
ligne des paragraphaes est justifiée spécifiquement.}
\end{document}
```


## Avec les commandes `\hangindent` et `\hangafter` 

Pour aligner les lignes au sein d'un même paragraphe, vous pouvez 
également utiliser les commandes `\hangindent` pour indiquer le retrait 
des lignes (pas seulement de la première ligne) et `\hangafter` 
pour spécifier à partir de quelle ligne ce retrait doit entrer en action.

L'exemple utilise ces même commandes pour faire une lettrine (avec un code 
à la manière de TeX) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \font\capfont=cmbx12 at 24.87 pt
  \newbox\capbox \newcount\capl \def\a{A}
  \def\docappar{%
    \medbreak\noindent
    \setbox\capbox\hbox{%
      \capfont\a\hskip0.15em}%
    \hangindent=\wd\capbox%
    \capl=\ht\capbox
    \divide\capl by\baselineskip
    \advance\capl by1%
    \hangafter=-\capl%
    \hbox{%
      \vbox to8pt{%
        \hbox to0pt{\hss\box\capbox}%
        \vss
      }%
    }%
  }
  \def\cappar{\afterassignment\docappar%
  \noexpand\let\a }

\begin{document}
\cappar Il était une fois un petit chaperon rouge qui avait une 
grand-mère qui habitait de l'autre côté de la forêt. Un jour, 
alors que sa grand-mère était malade, le petit chaperon rouge
décida de lui rendre visite...
\end{document}
```

Sur ce sujet des lettrines, vous pouvez consulter la question 
"[](/3_composition/texte/titres/commencer_un_paragraphe_par_une_lettrine)".


:::{sources}
- [hangindent hangafter document-wise settings](https://tex.stackexchange.com/q/641287), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::