/***********************************************************************
* 
*               *****   ***    ***
*                  *   *   *  *   *
*                 *     ***    ***
*                *     *   *  *   *
*               *****   ***    ***
*
* A FREE Finite Elements Analysis Program in ANSI C for the Windows
* and the UNIX OS.
*
* Composed and edited and copyright by 
* Professor Dr.-Ing. Frank Rieg, University of Bayreuth, Germany
*
* eMail: 
* frank.rieg@uni-bayreuth.de
* dr.frank.rieg@t-online.de
* 
* V15.0 November 18, 2015
*
* Z88 should compile and run under any Windows or UNIX OS and GTK+.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/ 
/***********************************************************************
* z88a.c mit Jennings-Speicherung
* 2.12.2015 Rieg
***********************************************************************/

/***********************************************************************
* Fuer UNIX
***********************************************************************/
#ifdef FR_UNIX
#include <z88r.h>
#include <stdio.h>
#endif

/***********************************************************************
* Fuer Windows
***********************************************************************/
#ifdef FR_WIN
#include <z88r.h>
#endif

/***********************************************************************
* Fuer Windows und GTK+
***********************************************************************/
#ifdef FR_GTKWIN
#include <z88r.h>
#endif

/***********************************************************************
*  Functions
***********************************************************************/
int wrim88r(FR_INT4,int);
int wlog88r(FR_INT4,int);
int wtya88j(FR_INT4,FR_INT4);

/***********************************************************************
* hier beginnt Function z88a
***********************************************************************/
int z88a(void)
{
extern FR_INT4AY ip;
extern FR_INT4AY koi;
extern FR_INT4AY ioffs; 
extern FR_INT4AY ifrei; 
extern FR_INT4AY koffs;
extern FR_INT4AY ityp;

extern FR_INT4 mcomp[];

extern FR_INT4 nkp,ne,nfg,kfoun;

FR_INT4 i,i2,j,j2,k,mxknot,mxfrei,mcompi,mcompj;

/*----------------------------------------------------------------------
* Start Function
*---------------------------------------------------------------------*/
wrim88r(0,TX_Z88A);
wlog88r(0,LOG_Z88A);

/***********************************************************************
* Berechnung des Offsetvektors ioffs
***********************************************************************/
ioffs[1]= 1;

for(i= 2;i <= nkp;i++)
  ioffs[i]= ioffs[i-1]+ifrei[i-1];

/***********************************************************************
* Aufbau der Skyline fuer gs,obere Haelfte
***********************************************************************/
/*----------------------------------------------------------------------
* ip auf Startwerte setzen
*---------------------------------------------------------------------*/
for(i= 1;i <= (nfg+1);i++)
  ip[i]= i;
 
/*----------------------------------------------------------------------
* grosse Formatierungsschleife
*---------------------------------------------------------------------*/
for(k= 1;k <= ne;k++)
  {
/*----------------------------------------------------------------------
*  es ist ityp(k):    1  isoparametrischer hexaeder, linearer ansatz
*                     2  balken
*                     3  scheibe, dreieckig, quadratischer ansatz
*                     4  stab
*                     5  welle
*                     6  torus, dreieckig, linearer ansatz
*                     7  isoparametrische scheibe, quadratischer ansatz
*                     8  isoparametrischer torus , quadratischer ansatz
*                     9  ebenes stabelement 
*                    10  isopara. hexaeder, quadratischer ansatz
*                    11  isoparametrische scheibe, kubischer ansatz
*                    12  isoparametrischer torus,  kubischer ansatz 
*                    13  ebener balken
*                    14  krummlinige dreiecksscheibe, quadr. ansatz
*                    15  krummliniger dreieckstorus, quadr. ansatz
*                    16  krummliniger tetraeder, quadr. ansatz
*                    17  tetraeder, linearer ansatz
*                    18  6-knoten serendipity-platte
*                    19  16-knoten lagrange-platte
*                    20  8-knoten serendipity-platte
*                    21  16-knoten volumenschalenele.
*                    22  12-knoten volumenschalenele.
*                    23  8-knoten flaches Schalenelement (Schei-Pla)
*                    24  6-knoten flaches Schalenelement (Schei-Pla)
*                    25  balken in allg.lage,Bernoulli + Timoshenko
*---------------------------------------------------------------------*/

/*----------------------------------------------------------------------
* Start 8-Knoten Quader, isoparametrischer linearer Ansatz
*---------------------------------------------------------------------*/
  if(ityp[k]== 1)
    {
    wtya88j(k,1);
 
/*----------------------------------------------------------------------
*   Formatieren fuer lqua88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 8;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 8;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-8-Knoten Quader
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
*  Start  Balkenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 2)
    {
    wtya88j(k,2);

/*----------------------------------------------------------------------
*   Formatieren fuer balk88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 6;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende Balkenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start Dreieck-Scheibenelement, quadratischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 3)
    {
    wtya88j(k,3);

/*----------------------------------------------------------------------
*   Formatieren fuer shei88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 6;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 6;
    mxfrei= 2;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende Scheibenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start Stabelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 4)
    {
    wtya88j(k,4);

/*----------------------------------------------------------------------
*   Formatieren fuer stab88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 3;

    goto L7000;
              
/*----------------------------------------------------------------------
*   Ende Stabelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
*  Start Wellenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 5)
    {
    wtya88j(k,5);

/*-----------------------------------------------------------------------
*   Formatieren fuer well88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 6;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende Wellenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start Toruselement, linearer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 6)
    {
    wtya88j(k,6);

/*----------------------------------------------------------------------
*   Formatieren fuer ring88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;
    mcomp[3]= ioffs[ koi[koffs[k]+2]] -1;

    mxknot= 3;
    mxfrei= 2;

    goto L7000;

/*-----------------------------------------------------------------------
*   Ende Toruselement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 8-knoten Scheibe/Torus, isoparametrischer quadratischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 7 || ityp[k]== 8)
    {
    if (ityp[k]== 7) wtya88j(k,7);
    if (ityp[k]== 8) wtya88j(k,8);
 
/*----------------------------------------------------------------------
*   Formatieren fuer qshe88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 8;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 8;
    mxfrei= 2;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-8-Knoten Scheibe/Torus
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start ebenes Stabelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 9)
    {
    wtya88j(k,9);

/*----------------------------------------------------------------------
*   Formatieren fuer esta88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 2;

    goto L7000;
         
/*----------------------------------------------------------------------
*   Ende ebenes Stabelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 20-Knoten Quader, isoparametrischer quadratischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 10)
    {
    wtya88j(k,10);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer hexa88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 20;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 20;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-20-Knoten Quader
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 12-knoten Scheibe/Torus, isoparametrischer kubischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 11 || ityp[k]== 12)
    {
    if (ityp[k]== 11) wtya88j(k,11);
    if (ityp[k]== 12) wtya88j(k,12);
 
/*----------------------------------------------------------------------
*   Formatieren fuer cshe88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 12;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 12;
    mxfrei= 2;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-12-Knoten Scheibe/Torus
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start  ebenes Balkenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 13)
    {
    wtya88j(k,13);

/*----------------------------------------------------------------------
*   Formatieren fuer ebal88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende ebenes Balkenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 6-knoten Dreieck- Scheibe/Torus, isop. quadratischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 14 || ityp[k]== 15)
    {
    if (ityp[k]== 14) wtya88j(k,14);
    if (ityp[k]== 15) wtya88j(k,15);

/*----------------------------------------------------------------------
*   Formatieren fuer isod88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 6;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 6;
    mxfrei= 2;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-6-Knoten Dreieck-Scheibe/Torus
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 10-Knoten Tetraeder, isoparametrischer quadratischer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 16)
    {
    wtya88j(k,16);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer tetr88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 10;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 10;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-10-Knoten Tetraeder
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 4-Knoten Tetraeder, linearer Ansatz
*---------------------------------------------------------------------*/
  else if(ityp[k]== 17)
    {
    wtya88j(k,17);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer spur88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 4;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 4;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende isopara-10-Knoten Tetraeder
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 6-Knoten Reissner- Mindlin Platte
*---------------------------------------------------------------------*/
  else if(ityp[k]== 18)
    {
    wtya88j(k,18);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer spla88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 6;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 6;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
* Ende 6-Knoten Reissner- Mindlin Platte
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 16-Knoten Lagrange- Platte
*---------------------------------------------------------------------*/
  else if(ityp[k]== 19)
    {
    wtya88j(k,19);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer hpla88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 16;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 16;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 16-Knoten Lagrange- Platte
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 8-Knoten Reissner- Mindlin Serendipity-Platte
*---------------------------------------------------------------------*/
  else if(ityp[k]== 20)
    {
    wtya88j(k,20);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer apla88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 8;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 8;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 8-Knoten Reissner- Mindlin Serendipity- Platte
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 16-Knoten Volumenschalenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 21)
    {
    wtya88j(k,21);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer shaq88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 16;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 16;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 16-Knoten Volumenschalenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 12-Knoten Volumenschalenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 22)
    {
    wtya88j(k,22);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer shad88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 12;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 12;
    mxfrei= 3;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 16-Knoten Volumenschalenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 8-Knoten flaches Schalenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 23)
    {
    wtya88j(k,23);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer shav88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 8;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 8;
    mxfrei= 6;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 8-Knoten flaches Schalenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
* Start 6-Knoten flaches Schalenelement
*---------------------------------------------------------------------*/
  else if(ityp[k]== 24)
    {
    wtya88j(k,24);
 
/*-----------------------------------------------------------------------
*   Formatieren fuer shaf88
*---------------------------------------------------------------------*/
    for(i= 1;i <= 6;i++)
      mcomp[i]= ioffs[ koi[koffs[k]+i-1]] -1;

    mxknot= 6;
    mxfrei= 6;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende 6-Knoten flaches Schalenelement
*---------------------------------------------------------------------*/
    }

/*----------------------------------------------------------------------
*  Start  Balkenelement Nr.25
*---------------------------------------------------------------------*/
  else if(ityp[k]== 25)
    {
    wtya88j(k,25);

/*----------------------------------------------------------------------
*   Formatieren fuer timo88
*---------------------------------------------------------------------*/
    mcomp[1]= ioffs[ koi[koffs[k]  ]] -1;
    mcomp[2]= ioffs[ koi[koffs[k]+1]] -1;

    mxknot= 2;
    mxfrei= 6;

    goto L7000;

/*----------------------------------------------------------------------
*   Ende Balkenelement
*---------------------------------------------------------------------*/
    }

  else
/*----------------------------------------------------------------------
* falscher/unbekannter Elementtyp
*---------------------------------------------------------------------*/
    {
    wlog88r(ityp[k],LOG_WROETYP);
    return(AL_WROETYP);
    }

/*----------------------------------------------------------------------
* nun Aufbau der Skyline
*---------------------------------------------------------------------*/
  L7000:;
  for(j= 1;j <= mxknot;j++)
    {
    for(j2= 1;j2 <= mxfrei;j2++)
      {
      for(i= 1;i <= mxknot;i++)
        {
        for(i2= 1;i2 <= mxfrei;i2++)
          {
          mcompi= mcomp[i]+i2;
          mcompj= mcomp[j]+j2;
          if(mcompj > mcompi) continue;
          if(ip[mcompi] > mcompj)
            ip[mcompi]= mcompj;
          }
        }
      }
    }

/***********************************************************************
* Ende der Schleife ueber alle Elemente
***********************************************************************/
  }                                              /* ende Form-Slei */

/***********************************************************************
* Aufbau von ip
***********************************************************************/
ip[1]= 1;
for(i= 2;i <= nfg; i++)
  ip[i]= ip[i-1] + (i - ip[i]) +1;

kfoun= ip[nfg];

/***********************************************************************
* Ende Z88A
***********************************************************************/
wrim88r(0,TX_CR);
wlog88r(0,LOG_EXITZ88A);
return(0);
}
