/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;

public class InlineContainerLayout
extends InlineStackingLayout
implements IInlineStackingLayout {
    IInlineStackingLayout lineParent = null;
    int lineCount = 1;

    public InlineContainerLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.isInBlockStacking = false;
        this.lineParent = (IInlineStackingLayout)((Object)parent);
    }

    @Override
    public void setTextIndent(ITextContent content) {
        this.lineParent.setTextIndent(content);
    }

    @Override
    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
        if (currentContext.root != null) {
            IStyle areaStyle = currentContext.root.getStyle();
            int width = currentContext.currentIP + this.getOffsetX() + this.getDimensionValue(areaStyle.getProperty(4)) + this.getDimensionValue(areaStyle.getProperty(10));
            if (this.lineCount == 1) {
                this.calculateSpecifiedWidth();
                if (this.specifiedWidth > width) {
                    width = this.specifiedWidth;
                }
            }
            currentContext.root.setWidth(width);
            int height = 0;
            Iterator iter = currentContext.root.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                height = Math.max(height, child.getAllocatedHeight());
            }
            currentContext.root.setContentHeight(height);
        }
        this.verticalAlign();
        this.parent.addToRoot((AbstractArea)currentContext.root, index);
    }

    @Override
    public void addToRoot(AbstractArea area) {
        this.currentContext.root.addChild(area);
        area.setAllocatedPosition(this.currentContext.currentIP, this.currentContext.currentBP);
        this.currentContext.currentIP += area.getAllocatedWidth();
    }

    @Override
    protected void createRoot() {
        this.currentContext.root = (ContainerArea)AreaFactory.createInlineContainer(this.content);
    }

    @Override
    protected void initialize() {
        this.currentContext = new ContainerLayout.ContainerContext();
        this.contextList.add(this.currentContext);
        this.createRoot();
        this.currentContext.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.currentContext.maxAvaHeight = this.parent.getCurrentMaxContentHeight();
        this.currentContext.currentBP = this.currentContext.root.getContentY();
        this.currentContext.currentIP = this.currentContext.root.getContentX();
    }

    @Override
    public boolean endLine() throws BirtException {
        ++this.lineCount;
        boolean ret = true;
        if (this.currentContext.root != null && this.currentContext.root.getChildrenCount() > 0) {
            this.closeLayout();
        }
        if (this.lineParent != null) {
            ret = this.lineParent.endLine();
            this.initialize();
        }
        return ret;
    }

    @Override
    public int getMaxLineWidth() {
        return this.lineParent.getMaxLineWidth();
    }

    @Override
    public boolean isEmptyLine() {
        if (this.currentContext.root != null && this.currentContext.root.getChildrenCount() > 0) {
            return false;
        }
        return this.lineParent.isEmptyLine();
    }
}

