/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;

class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(WorkbenchNavigatorMessages.PasteAction_Past_);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(WorkbenchNavigatorMessages.PasteAction_Paste_selected_resource_s_);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    private IResource getTarget() {
        List selectedResources = this.getSelectedResources();
        for (IResource resource : selectedResources) {
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return null;
            }
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                int i = 0;
                while (i < resourceData.length) {
                    CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                    operation.copyProject((IProject)resourceData[i]);
                    ++i;
                }
            } else {
                IContainer container = this.getContainer();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                operation.copyResources(resourceData, container);
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            IContainer container = this.getContainer();
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(fileData, container);
        }
    }

    private IContainer getContainer() {
        List selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        final IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ResourceTransfer resTransfer = ResourceTransfer.getInstance();
                clipboardData[0] = (IResource[])PasteAction.this.clipboard.getContents((Transfer)resTransfer);
            }
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            int i = 0;
            while (i < resourceData.length) {
                if (resourceData[i].getType() != 4 || !((IProject)resourceData[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            for (IResource resource : selectedResources) {
                if (resource.getType() != 1) {
                    return false;
                }
                if (targetResource.equals((Object)resource.getParent())) continue;
                return false;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4 && targetResource.getType() != 2) {
                return false;
            }
            if (targetResource.getType() == 2) {
                int i = 0;
                while (i < resourceData.length) {
                    if (targetResource.equals((Object)resourceData[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        TransferData[] transfers = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        int i = 0;
        while (i < transfers.length) {
            if (fileTransfer.isSupportedType(transfers[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

