; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i1 @test_second_and_condition_implied_by_first(i8 %x) {
; CHECK-LABEL: @test_second_and_condition_implied_by_first(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[T_1:%.*]] = icmp ugt i8 [[X]], 5
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[T_1]]
; CHECK-NEXT:    br i1 [[AND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i1 false
; CHECK:       else:
; CHECK-NEXT:    ret i1 true
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %t.1 = icmp ugt i8 %x, 5
  %and = and i1 %c.1, %t.1
  br i1 %and, label %then, label %else

then:
  ret i1 0

else:
  ret i1 1
}

define i1 @test_same_cond_for_and(i8 %x) {
; CHECK-LABEL: @test_same_cond_for_and(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_1]]
; CHECK-NEXT:    br i1 [[AND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i1 false
; CHECK:       else:
; CHECK-NEXT:    ret i1 true
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %and = and i1 %c.1, %c.1
  br i1 %and, label %then, label %else

then:
  ret i1 0

else:
  ret i1 1
}

define i1 @test_second_and_condition_not_implied_by_first(i8 %x) {
; CHECK-LABEL: @test_second_and_condition_not_implied_by_first(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C_1:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[C_2:%.*]] = icmp ugt i8 [[X]], 5
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_2]], [[C_1]]
; CHECK-NEXT:    br i1 [[AND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    ret i1 false
; CHECK:       else:
; CHECK-NEXT:    ret i1 true
;
entry:
  %c.1 = icmp ugt i8 %x, 10
  %c.2 = icmp ugt i8 %x, 5
  %and = and i1 %c.2, %c.1
  br i1 %and, label %then, label %else

then:
  ret i1 0

else:
  ret i1 1
}
